<?php
session_start();
include "../config/db.php";

$error = "";
$success = "";

/* GET REFERRAL ID FROM URL */
$refBy = isset($_GET['ref']) ? (int)$_GET['ref'] : null;

if(isset($_POST['register'])){

    $username = trim($_POST['username']);
    $mobile   = trim($_POST['mobile']);
    $email    = trim($_POST['email']);
    $address  = trim($_POST['address']);
    $pass     = $_POST['password'];
    $confirm  = $_POST['confirm'];

    if($pass !== $confirm){
        $error = "Passwords do not match";
    } else {

        /* CHECK EMAIL */
        $q = $conn->prepare("SELECT id FROM users WHERE email=?");
        $q->execute([$email]);

        if($q->rowCount()){
            $error = "Email already registered";
        } else {

            /* INSERT USER WITH REFERRAL */
            $conn->prepare(
                "INSERT INTO users
                (username,mobile,email,address,password,ref_by)
                VALUES (?,?,?,?,?,?)"
            )->execute([
                $username,
                $mobile,
                $email,
                $address,
                md5($pass),
                $refBy
            ]);

            $success = "✅ Account created successfully. Please login.";
        }
    }
}
?>
<!DOCTYPE html>
<html>
<head>
<title>User Register</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="/assets/css/outside.css">
</head>

<body>

<header>
    <div class="logo">DrJomax</div>
    <nav>
        <a href="/">Home</a>
        <a href="/user/login.php">Login</a>
    </nav>
</header>

<div class="form-box">
<h2>Create Account</h2>

<?php if($error): ?>
<div class="error"><?= $error ?></div>
<?php endif; ?>

<?php if($success): ?>
<div class="success"><?= $success ?></div>
<?php endif; ?>

<form method="post">
<input name="username" placeholder="Full Name" required>
<input name="mobile" placeholder="Mobile Number" required>
<input name="email" placeholder="Email" required>
<input name="address" placeholder="Address" required>
<input type="password" name="password" placeholder="Password" required>
<input type="password" name="confirm" placeholder="Confirm Password" required>

<button type="submit" name="register">Register</button>
</form>

<?php if($refBy): ?>
<p style="margin-top:10px;color:#16a34a;font-size:14px">
🎁 You are joining via referral
</p>
<?php endif; ?>

</div>

</body>
</html>
