<?php
ini_set('display_errors',1);
error_reporting(E_ALL);

session_start();
include "../config/db.php";

$error = "";

if(isset($_POST['login'])){

    $email = trim($_POST['email']);
    $pass  = trim($_POST['password']);

    if($email=="" || $pass==""){
        $error = "All fields required";
    } else {

        $q = $conn->prepare("SELECT * FROM users WHERE email=?");
        $q->execute([$email]);
        $u = $q->fetch(PDO::FETCH_ASSOC);

        if(!$u){
            $error = "Invalid email or password";
        }
        elseif($u['status'] != 1){
            $error = "Account inactive by admin";
        }
        elseif(md5($pass) != $u['password']){
            $error = "Invalid email or password";
        }
        else{
            $_SESSION['user_id'] = $u['id'];

            // 🔥 IMPORTANT FLAG (QR FIX)
            $_SESSION['login_success'] = true;

            header("Location: dashboard.php");
            exit;
        }
    }
}
?>
<!DOCTYPE html>
<html>
<head>
<title>User Login</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="/assets/css/outside.css">
</head>

<body>

<div class="login-wrap">

  <div class="login-slider">
    <div class="slide active">
      <h2>Welcome 👋</h2>
      <p>Fast & secure digital wallet</p>
    </div>
    <div class="slide">
      <h2>Instant Withdraw</h2>
      <p>Get money directly to bank</p>
    </div>
    <div class="slide">
      <h2>QR Coupon Redeem</h2>
      <p>Scan & earn instantly</p>
    </div>
  </div>

  <div class="login-form">
    <h2>User Login</h2>

    <?php if($error): ?>
      <div class="error"><?= $error ?></div>
    <?php endif; ?>

    <form method="post">
      <input type="email" name="email" placeholder="Email" required>
      <input type="password" name="password" placeholder="Password" required>
      <button type="submit" name="login">Login</button>
    </form>
  </div>

</div>

<script>
let i = 0;
const slides = document.querySelectorAll(".slide");
setInterval(()=>{
  slides[i].classList.remove("active");
  i = (i + 1) % slides.length;
  slides[i].classList.add("active");
},3000);
</script>

</body>
</html>
