<?php
ini_set('display_errors',1);
error_reporting(E_ALL);

session_start();
include "../config/db.php";

if(!isset($_SESSION['user_id'])){
    header("Location: login.php");
    exit;
}
$userId = $_SESSION['user_id'];

/* USER */
$u = $conn->prepare("SELECT * FROM users WHERE id=?");
$u->execute([$userId]);
$user = $u->fetch(PDO::FETCH_ASSOC);

/* BANK */
$bq = $conn->prepare("SELECT * FROM user_banks WHERE user_id=?");
$bq->execute([$userId]);
$bank = $bq->fetch(PDO::FETCH_ASSOC);

/* WITHDRAW SETTINGS */
$ws = $conn->query(
    "SELECT charge_percent,min_amount FROM withdraw_settings WHERE id=1"
)->fetch(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
<title>User Dashboard</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="/assets/css/inside.css">
</head>

<body>

<div class="menu-btn" onclick="toggleMenu()">☰</div>

<!-- ================= MENU ================= -->
<div id="menu" class="menu">
    <a onclick="openSec('profile')">👤 Profile</a>
    <a onclick="openSec('wallet')">👛 Wallet</a>
    <a onclick="openSec('bank')">🏦 Add Bank</a>
    <a onclick="openSec('withdraw')">💸 Withdraw</a>
    <a onclick="openSec('withdraw_history')">📜 Withdraw History</a>
    <a onclick="openSec('referral')">🤝 Referral</a>
    <a href="https://drjomax.shop/redeem.php" target="_blank">📷 Redeem Coupon</a>
    <a onclick="openSec('redeem_history')">🧾 Coupon History</a>
    <a href="logout.php">🚪 Logout</a>
</div>

<!-- ================= PROFILE ================= -->
<div id="profile" class="section active">
<div class="card" style="text-align:center;">
<h2>My Profile</h2>
<img src="uploads/<?= $user['photo'] ?: 'default.png'; ?>" class="avatar"><br><br>
<p><?= htmlspecialchars($user['username']); ?></p>
<p><?= htmlspecialchars($user['email']); ?></p>
<p><?= htmlspecialchars($user['mobile']); ?></p>
<p><?= htmlspecialchars($user['address']); ?></p>
</div>
</div>

<!-- ================= WALLET ================= -->
<div id="wallet" class="section">
<div class="card" style="text-align:center">
<p style="color:#64748b">Wallet Balance</p>
<div class="wallet-amount">
₹<?= number_format($user['wallet'],2); ?>
</div>
</div>
</div>

<!-- ================= BANK ================= -->
<div id="bank" class="section">
<div class="card">
<h2>Add Bank</h2>
<form method="post">
<input name="bank_name" placeholder="Bank Name" required>
<input name="holder" placeholder="Account Holder Name" required>
<input name="account" placeholder="Account Number" required>
<input name="ifsc" placeholder="IFSC Code" required>
<button name="save_bank">Save Bank</button>
</form>
</div>
</div>

<!-- ================= WITHDRAW ================= -->
<div id="withdraw" class="section">
<div class="card">
<h2>Withdraw</h2>
<p>Charge: <?= $ws['charge_percent']; ?>%</p>
<p>Minimum: ₹<?= $ws['min_amount']; ?></p>
<form method="post">
<input type="number" step="0.01" name="amount" required>
<button name="withdraw">Withdraw</button>
</form>
</div>
</div>

<!-- ================= WITHDRAW HISTORY ================= -->
<div id="withdraw_history" class="section">
<div class="card">
<h2>📜 Withdraw History</h2>
<table width="100%" border="1" cellpadding="6">
<tr>
<th>Date</th><th>Amount</th><th>Charge</th><th>Final</th><th>Status</th>
</tr>
<?php
$wh = $conn->prepare(
    "SELECT * FROM withdrawals WHERE user_id=? ORDER BY created_at DESC"
);
$wh->execute([$userId]);
if($wh->rowCount()==0){
    echo "<tr><td colspan='5'>No withdrawals yet</td></tr>";
}
foreach($wh as $w){
    echo "<tr>
    <td>{$w['created_at']}</td>
    <td>₹{$w['amount']}</td>
    <td>₹{$w['charge']}</td>
    <td>₹{$w['final_amount']}</td>
    <td>{$w['status']}</td>
    </tr>";
}
?>
</table>
</div>
</div>

<!-- ================= COUPON REDEEM HISTORY ================= -->
<div id="redeem_history" class="section">
<div class="card">

<h2>🧾 Coupon Redeem History</h2>

<table width="100%" border="1" cellpadding="6">
<tr>
<th>Date</th>
<th>Coupon Name</th>
<th>Coupon Code</th>
<th>Size</th>
<th>Amount</th>
<th>Product Code</th>
</tr>

<?php
$rh = $conn->prepare(
    "SELECT 
        r.redeemed_at,
        r.coupon_code,
        r.product_code,
        c.coupon_name,
        c.size,
        c.amount
     FROM coupon_redeems r
     LEFT JOIN coupons c
        ON c.coupon_code = r.coupon_code
     WHERE r.user_id=?
     ORDER BY r.redeemed_at DESC"
);
$rh->execute([$userId]);

if($rh->rowCount()==0){
    echo "<tr><td colspan='6'>No coupon redeemed yet</td></tr>";
}

foreach($rh as $r){
    echo "<tr>
    <td>{$r['redeemed_at']}</td>
    <td>".htmlspecialchars($r['coupon_name'] ?? '-')."</td>
    <td>{$r['coupon_code']}</td>
    <td>{$r['size']}</td>
    <td>₹{$r['amount']}</td>
    <td>{$r['product_code']}</td>
    </tr>";
}
?>
</table>

</div>
</div>

<!-- ================= REFERRAL ================= -->
<div id="referral" class="section">
<div class="card">

<h2>🤝 My Referral Dashboard</h2>

<?php
$refCount = $conn->prepare("SELECT COUNT(*) FROM users WHERE ref_by=?");
$refCount->execute([$userId]);
$totalRefs = $refCount->fetchColumn();

$refEarn = $conn->prepare(
    "SELECT COALESCE(SUM(amount),0)
     FROM referral_earnings WHERE referrer_id=?"
);
$refEarn->execute([$userId]);
$totalEarn = $refEarn->fetchColumn();
?>

<p>Total Referrals: <b><?= $totalRefs ?></b></p>
<p>Total Referral Earnings:
<b style="color:#7CFF00">₹<?= number_format($totalEarn,2) ?></b></p>

<input
 value="https://drjomax.shop/user/register.php?ref=<?= $userId ?>"
 readonly
 onclick="this.select()"
 style="width:100%;padding:10px;border-radius:8px;border:none">

</div>
</div>

<script>
function toggleMenu(){
 document.getElementById('menu').classList.toggle("open");
}
function openSec(id){
 document.querySelectorAll('.section').forEach(s=>s.classList.remove('active'));
 document.getElementById(id).classList.add('active');
 toggleMenu();
}
</script>

</body>
</html>
