<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['user_id'])) {
    header("Location: user/login.php");
    exit;
}

include "config/db.php";
?>
<!DOCTYPE html>
<html>
<head>
<title>Redeem Coupon</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<style>
body{
    margin:0;
    background:#000;
    color:#fff;
    font-family:Arial, sans-serif;
    padding:20px;
    text-align:center;
}
h2{margin-bottom:15px;}
#reader{
    width:100%;
    min-height:320px;
    border:3px solid #7CFF00;
    border-radius:12px;
    margin:15px 0;
}
button{
    padding:15px 25px;
    margin:8px;
    background:#7CFF00;
    border:none;
    font-size:16px;
    font-weight:bold;
    cursor:pointer;
    border-radius:10px;
}
input{
    width:100%;
    padding:12px;
    font-size:16px;
    border-radius:8px;
    border:none;
}
.result{margin-top:15px;font-size:16px;}
</style>

<!-- 🔥 FORCE TOP WINDOW + BLOCK IN-APP BROWSERS -->
<script>
(function () {
    if (window.top !== window.self) {
        window.top.location = window.location.href;
    }
    const ua = navigator.userAgent || "";
    if (
        ua.includes("Instagram") ||
        ua.includes("FBAN") ||
        ua.includes("FBAV") ||
        ua.includes("WhatsApp")
    ) {
        alert("⚠️ QR Scan ke liye page Chrome / Safari me open karein");
    }
})();
</script>

</head>

<body>

<h2>Redeem Coupon (QR Scan)</h2>

<button onclick="startFront()">Front Camera</button>
<button onclick="startBack()">Back Camera</button>

<div id="reader"></div>

<form method="post">
    <input type="text" id="coupon_code" name="coupon_code"
           placeholder="Enter or Scan Coupon Code" required>
    <br><br>
    <button name="redeem_code">Redeem Coupon</button>
</form>

<div class="result">
<?php
if (isset($_POST['redeem_code'])) {

    $code   = strtoupper(trim($_POST['coupon_code']));
    $today  = date("Y-m-d");
    $userId = $_SESSION['user_id'];

    /* CURRENT USER */
    $u = $conn->prepare("SELECT id, ref_by FROM users WHERE id=?");
    $u->execute([$userId]);
    $user = $u->fetch(PDO::FETCH_ASSOC);

    /* COUPON */
    $stmt = $conn->prepare(
        "SELECT * FROM coupons
         WHERE coupon_code = ?
         AND is_used = 0
         AND expiry_date >= ?"
    );
    $stmt->execute([$code, $today]);
    $cp = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($cp) {

        /* MARK COUPON USED */
        $conn->prepare(
            "UPDATE coupons SET is_used = 1 WHERE id = ?"
        )->execute([$cp['id']]);

        /* SAVE REDEEM */
        $conn->prepare(
            "INSERT INTO coupon_redeems (user_id, coupon_code, product_code)
             VALUES (?,?,?)"
        )->execute([
            $userId,
            $cp['coupon_code'],
            $cp['product_code']
        ]);

        /* ===============================
           🔥 REFERRAL COMMISSION LOGIC
        ================================ */
        if (!empty($user['ref_by']) && $cp['ref_percent'] > 0) {

            $refUserId = (int)$user['ref_by'];

            $commission = round(
                ($cp['amount'] * $cp['ref_percent']) / 100,
                2
            );

            if ($commission > 0) {

                /* ADD COMMISSION TO REFERRER WALLET */
                $conn->prepare(
                    "UPDATE users SET wallet = wallet + ? WHERE id = ?"
                )->execute([$commission, $refUserId]);

                /* SAVE REFERRAL HISTORY */
                $conn->prepare(
                    "INSERT INTO referral_earnings
                    (referrer_id, from_user, coupon_code, amount, percent)
                    VALUES (?,?,?,?,?)"
                )->execute([
                    $refUserId,
                    $userId,
                    $cp['coupon_code'],
                    $commission,
                    $cp['ref_percent']
                ]);
            }
        }

        echo "
        ✅ Coupon Redeemed Successfully<br><br>
        <b>Product Code:</b><br>
        <span style='color:#7CFF00;font-size:22px;'>
            {$cp['product_code']}
        </span>
        ";

    } else {
        echo "❌ Invalid / Expired / Already Used Coupon";
    }
}
?>
</div>

<!-- QR LIB -->
<script src="https://unpkg.com/html5-qrcode"></script>

<script>
let qrScanner = null;

function startBack(){
    if (!window.isSecureContext) {
        alert("❌ Camera ke liye HTTPS zaroori hai");
        return;
    }

    Html5Qrcode.getCameras().then(devices => {
        if(!devices || devices.length === 0){
            alert("❌ Camera not found");
            return;
        }
        const backCam = devices[devices.length - 1].id;
        qrScanner = new Html5Qrcode("reader");
        qrScanner.start(
            backCam,
            { fps: 10, qrbox: 250 },
            text => {
                document.getElementById("coupon_code").value = text;
                qrScanner.stop();
            }
        );
    });
}

function startFront(){
    if (!window.isSecureContext) {
        alert("❌ Camera ke liye HTTPS zaroori hai");
        return;
    }

    qrScanner = new Html5Qrcode("reader");
    qrScanner.start(
        { facingMode: "user" },
        { fps: 10, qrbox: 250 },
        text => {
            document.getElementById("coupon_code").value = text;
            qrScanner.stop();
        }
    );
}
</script>

</body>
</html>
