<?php
function generateCouponPNG($data){

    $width = 600;
    $height = 360;

    // CREATE IMAGE
    $im = imagecreatetruecolor($width, $height);

    // COLORS
    $black = imagecolorallocate($im, 0, 0, 0);
    $white = imagecolorallocate($im, 255, 255, 255);
    $green = imagecolorallocate($im, 124, 255, 0);

    imagefill($im, 0, 0, $black);

    // OPTIONAL BACKGROUND IMAGE
    if(!empty($data['bg']) && file_exists($data['bg'])){
        $bg = imagecreatefromstring(file_get_contents($data['bg']));
        imagecopyresampled($im, $bg, 0,0,0,0,$width,$height, imagesx($bg), imagesy($bg));
        imagedestroy($bg);
    }

    // FONT
    $font = __DIR__ . "/fonts/arial.ttf"; // upload arial.ttf here

    // TEXT
    imagettftext($im, 20, 0, 30, 50, $white, $font, $data['name']);
    imagettftext($im, 14, 0, 30, 100, $green, $font, "Code:");
    imagettftext($im, 14, 0, 120, 100, $white, $font, $data['code']);

    imagettftext($im, 14, 0, 30, 140, $green, $font, "Size:");
    imagettftext($im, 14, 0, 120, 140, $white, $font, $data['size']);

    imagettftext($im, 14, 0, 30, 180, $green, $font, "Amount:");
    imagettftext($im, 14, 0, 140, 180, $white, $font, "₹".$data['amount']);

    imagettftext($im, 12, 0, 200, 330, $green, $font, "Product: ".$data['product']);

    // QR CODE
    $qrRaw = file_get_contents(
        "https://api.qrserver.com/v1/create-qr-code/?size=120x120&data=".$data['code']
    );
    if($qrRaw){
        $qr = imagecreatefromstring($qrRaw);
        imagecopy($im, $qr, 440, 120, 0,0,120,120);
        imagedestroy($qr);
    }

    // SAVE PNG
    imagepng($im, $data['save']);
    imagedestroy($im);
}
