<style>
/* ===== RESET ===== */
*{margin:0;padding:0;box-sizing:border-box;}
body{
    font-family:Arial, sans-serif;
    background:#000;
    color:#fff;
}

/* ===== DESKTOP NAV ===== */
.desktop-nav{
    display:flex;
    justify-content:space-between;
    align-items:center;
    padding:20px 40px;
}
.desktop-nav a{
    color:#fff;
    text-decoration:none;
    margin:0 15px;
    font-size:16px;
}
.desktop-nav a.active{color:#7CFF00;}
.desktop-right{display:flex;align-items:center;}

/* ===== MOBILE MENU BUTTON ===== */
.menu-btn{
    position:fixed;
    top:20px;
    right:20px;
    width:55px;
    height:55px;
    background:#7CFF00;
    border-radius:15px;
    font-size:28px;
    color:#000;
    display:none;
    align-items:center;
    justify-content:center;
    cursor:pointer;
    z-index:9999;
}

/* ===== MOBILE MENU ===== */
.menu{
    position:fixed;
    inset:0;
    background:#000;
    padding:120px 40px;
    transform:translateX(-100%);
    transition:.4s;
    z-index:9998;
}
.menu.open{transform:translateX(0);}
.menu a{
    display:block;
    font-size:28px;
    margin:28px 0;
    color:#fff;
    text-decoration:none;
}
.menu a.active{color:#7CFF00;}
.user-box{margin-top:40px;color:#7CFF00;}

@media (max-width:900px){
    .desktop-nav{display:none;}
    .menu-btn{display:flex;}
}
@media (min-width:901px){
    .menu{display:none;}
}

/* ================= HERO ================= */

.hero{
    position:relative;
    height:100vh;
    overflow:hidden;
    background:#000;
}

/* ===== IMAGE SLIDER ===== */
.bg-slider{
    position:absolute;
    inset:0;
    background-size:cover;
    background-position:center;
    animation:imageSlide 18s infinite ease-in-out;
    filter:brightness(0.9);
    z-index:0;
}

@keyframes imageSlide{
    0%{background-image:url('/assets/slider/bg1.jpg');}
    33%{background-image:url('/assets/slider/bg2.jpg');}
    66%{background-image:url('/assets/slider/bg3.jpg');}
    100%{background-image:url('/assets/slider/bg1.jpg');}
}

/* ===== SOFT BLACK OVERLAY ===== */
.hero::before{
    content:"";
    position:absolute;
    inset:0;
    background:rgba(0,0,0,0.25);
    z-index:1;
}

/* ===== HERO CONTENT ===== */
.hero-content{
    position:relative;
    z-index:2;
    height:100%;
    display:flex;
    flex-direction:column;
    justify-content:center;
    align-items:center;
    text-align:center;
    background:transparent;
    padding:20px;
}

.hero h1{
    font-size:42px;
    margin-bottom:15px;
}
.hero h1 span{
    color:#7CFF00;
}
.hero p{
    color:#ccc;
    margin-bottom:30px;
    line-height:1.6;
}

/* ===== BUTTONS ===== */
.hero-btns{
    display:flex;
    gap:15px;
}

.btn{
    padding:14px 36px;
    border-radius:40px;
    text-decoration:none;
    font-weight:bold;
}

.btn.primary{
    background:#7CFF00;
    color:#000;
}

.btn.outline{
    border:2px solid #7CFF00;
    color:#7CFF00;
}

@media (max-width:768px){
    .hero h1{font-size:28px;}
    .hero p{font-size:14px;}
    .hero-btns{flex-direction:column;}
}
</style>
