<!DOCTYPE html>
<html>
<head>
<title>Camera Test</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<style>
body{
    background:#000;
    color:#fff;
    font-family:Arial;
    text-align:center;
    padding:20px;
}
#reader{
    width:100%;
    min-height:300px;
    border:3px solid #7CFF00;
    margin-top:20px;
}
button{
    padding:15px 25px;
    margin:10px;
    font-size:16px;
    background:#7CFF00;
    border:none;
    font-weight:bold;
}
</style>
</head>

<body>

<h2>Camera Test</h2>

<button onclick="startCamera()">Start Camera</button>

<div id="reader"></div>

<script src="https://unpkg.com/html5-qrcode"></script>

<script>
function startCamera(){
    const qr = new Html5Qrcode("reader");

    qr.start(
        { facingMode: "environment" },
        { fps: 10, qrbox: 250 },
        msg => alert("Scanned: " + msg),
        err => {}
    ).catch(e=>{
        alert("Camera failed: " + e);
        console.log(e);
    });
}
</script>

</body>
</html>
