<?php
ini_set('display_errors',1);
error_reporting(E_ALL);

session_start();
include "../config/db.php";

if(!isset($_SESSION['admin'])){
    header("Location: index.php");
    exit;
}

/* APPROVE */
if(isset($_GET['approve'])){
    $id = (int)$_GET['approve'];
    $conn->prepare(
        "UPDATE withdrawals SET status='Approved' WHERE id=?"
    )->execute([$id]);
}

/* REJECT + REFUND FULL AMOUNT */
if(isset($_POST['reject'])){
    $id = (int)$_POST['id'];
    $reason = $_POST['reason'];

    $q = $conn->prepare(
        "SELECT user_id, amount FROM withdrawals WHERE id=?"
    );
    $q->execute([$id]);
    $wd = $q->fetch(PDO::FETCH_ASSOC);

    if($wd){
        // refund full amount to wallet
        $conn->prepare(
            "UPDATE users SET wallet = wallet + ? WHERE id=?"
        )->execute([$wd['amount'], $wd['user_id']]);

        $conn->prepare(
            "UPDATE withdrawals 
             SET status='Rejected', reject_reason=? 
             WHERE id=?"
        )->execute([$reason, $id]);
    }
}

/* FETCH WITHDRAW REQUESTS + BANK + CHARGE INFO */
$sql = "
SELECT 
    w.id,
    w.amount,
    w.charge,
    w.final_amount,
    w.status,
    w.created_at,
    w.reject_reason,

    u.username,
    u.mobile,

    b.bank_name,
    b.holder_name,
    b.account_number,
    b.ifsc

FROM withdrawals w
JOIN users u ON u.id = w.user_id
LEFT JOIN user_banks b ON b.user_id = u.id
ORDER BY w.created_at DESC
";

$data = $conn->query($sql);
?>

<!DOCTYPE html>
<html>
<head>
<title>Withdraw Requests</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
body{background:#000;color:#fff;font-family:Arial;padding:20px;}
table{width:100%;border-collapse:collapse;}
th,td{border:1px solid #444;padding:8px;font-size:14px;vertical-align:top;}
th{background:#111;}
a{color:#7CFF00;font-weight:bold;}
button{padding:6px 10px;margin-top:5px;}
.amount-box{font-size:13px;line-height:1.5;}
</style>
</head>

<body>

<h2>Withdraw Requests</h2>

<table>
<tr>
<th>ID</th>
<th>User</th>
<th>Mobile</th>
<th>Bank Details</th>
<th>Amount Details</th>
<th>Status</th>
<th>Date</th>
<th>Action</th>
</tr>

<?php foreach($data as $r): ?>
<tr>
<td><?= $r['id']; ?></td>

<td><?= htmlspecialchars($r['username']); ?></td>

<td><?= htmlspecialchars($r['mobile']); ?></td>

<td>
<b>Bank:</b> <?= htmlspecialchars($r['bank_name']); ?><br>
<b>Holder:</b> <?= htmlspecialchars($r['holder_name']); ?><br>
<b>A/C:</b> <?= htmlspecialchars($r['account_number']); ?><br>
<b>IFSC:</b> <?= htmlspecialchars($r['ifsc']); ?>
</td>

<td class="amount-box">
<b>Requested:</b> ₹<?= number_format($r['amount'],2); ?><br>
<b>Charge:</b> ₹<?= number_format($r['charge'],2); ?><br>
<b style="color:#7CFF00;">Payable:</b>
₹<?= number_format($r['final_amount'],2); ?>
</td>

<td><?= $r['status']; ?></td>

<td><?= $r['created_at']; ?></td>

<td>
<?php if($r['status']=='Pending'): ?>

<a href="?approve=<?= $r['id']; ?>">Approve</a>

<form method="post">
<input type="hidden" name="id" value="<?= $r['id']; ?>">
<input name="reason" placeholder="Reject reason" required>
<button name="reject">Reject</button>
</form>

<?php else: ?>
<?= htmlspecialchars($r['reject_reason']); ?>
<?php endif; ?>
</td>

</tr>
<?php endforeach; ?>
</table>

<br>
<a href="dashboard.php">⬅ Back to Dashboard</a>

</body>
</html>
