<?php
session_start();
include "../config/db.php";

if (!isset($_SESSION['admin'])) {
    die("Admin login required");
}

$id = (int)$_GET['id'];
$action = $_GET['action'] ?? '';

$w = $conn->prepare("SELECT * FROM withdrawals WHERE id=?");
$w->execute([$id]);
$wd = $w->fetch(PDO::FETCH_ASSOC);

if (!$wd || $wd['status'] !== 'Pending') {
    header("Location: withdraw-requests.php");
    exit;
}

if ($action === 'approve') {

    $conn->prepare(
        "UPDATE withdrawals SET status='Approved' WHERE id=?"
    )->execute([$id]);

} elseif ($action === 'reject') {

    // refund wallet
    $conn->prepare(
        "UPDATE users SET wallet = wallet + ? WHERE id=?"
    )->execute([$wd['amount'], $wd['user_id']]);

    $conn->prepare(
        "UPDATE withdrawals SET status='Rejected' WHERE id=?"
    )->execute([$id]);
}

header("Location: withdraw-requests.php");
exit;
