<?php
ini_set('display_errors',1);
error_reporting(E_ALL);

session_start();
include "../config/db.php";

if(!isset($_SESSION['admin'])){
    header("Location: index.php");
    exit;
}

/* ==============================
   ADMIN CHANGE USER PHOTO
   ============================== */
if(isset($_POST['admin_photo']) && isset($_FILES['photo'])){
    $uid = (int)$_POST['uid'];

    $name = time()."_".$_FILES['photo']['name'];
    move_uploaded_file(
        $_FILES['photo']['tmp_name'],
        "../user/uploads/".$name
    );

    $conn->prepare(
        "UPDATE users SET photo=? WHERE id=?"
    )->execute([$name,$uid]);
}

/* ==============================
   LOGIN AS USER
   ============================== */
if(isset($_GET['login'])){
    $_SESSION['user_id'] = (int)$_GET['login'];
    header("Location: ../user/dashboard.php");
    exit;
}

/* ==============================
   UPDATE USER (WALLET / STATUS / PASSWORD)
   ============================== */
if(isset($_POST['update'])){
    $id = (int)$_POST['id'];
    $wallet = $_POST['wallet'];
    $status = $_POST['status'];

    if(!empty($_POST['password'])){
        $pass = md5($_POST['password']);
        $conn->prepare(
            "UPDATE users 
             SET wallet=?, status=?, password=? 
             WHERE id=?"
        )->execute([$wallet,$status,$pass,$id]);
    } else {
        $conn->prepare(
            "UPDATE users 
             SET wallet=?, status=? 
             WHERE id=?"
        )->execute([$wallet,$status,$id]);
    }
}

/* ==============================
   FETCH USERS
   ============================== */
$users = $conn->query(
    "SELECT * FROM users ORDER BY id DESC"
);
?>

<!DOCTYPE html>
<html>
<head>
<title>User List</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
body{font-family:Arial;background:#000;color:#fff;padding:20px;}
table{width:100%;border-collapse:collapse;}
th,td{border:1px solid #444;padding:8px;font-size:14px;vertical-align:top;}
th{background:#111;}
input,select,button{padding:6px;margin:4px 0;}
button{cursor:pointer;}
img{width:60px;height:60px;border-radius:50%;object-fit:cover;}
.action-box{margin-bottom:10px;}
a{color:#7CFF00;}
</style>
</head>

<body>

<h2>User List</h2>

<table>
<tr>
<th>ID</th>
<th>Photo</th>
<th>Name</th>
<th>Mobile</th>
<th>Email</th>
<th>Address</th>
<th>Wallet</th>
<th>Status</th>
<th>Action</th>
</tr>

<?php foreach($users as $r): ?>
<tr>

<!-- UPDATE USER FORM -->
<form method="post">
<td>
<?= $r['id']; ?>
<input type="hidden" name="id" value="<?= $r['id']; ?>">
</td>

<td>
<img src="../user/uploads/<?= $r['photo'] ?: 'default.png'; ?>">
</td>

<td><?= htmlspecialchars($r['username']); ?></td>
<td><?= htmlspecialchars($r['mobile']); ?></td>
<td><?= htmlspecialchars($r['email']); ?></td>
<td><?= htmlspecialchars($r['address']); ?></td>

<td>
<input name="wallet" value="<?= $r['wallet']; ?>" style="width:80px;">
</td>

<td>
<select name="status">
<option value="1" <?= $r['status']?'selected':''; ?>>Active</option>
<option value="0" <?= !$r['status']?'selected':''; ?>>Inactive</option>
</select>
</td>

<td>
<div class="action-box">
<input name="password" placeholder="New Password">
<button name="update">Update</button>
</div>

<div class="action-box">
<a href="?login=<?= $r['id']; ?>">Login as User</a>
</div>
</td>
</form>

<!-- ADMIN CHANGE PHOTO FORM -->
<td>
<form method="post" enctype="multipart/form-data">
<input type="hidden" name="uid" value="<?= $r['id']; ?>">
<input type="file" name="photo" accept="image/*" required>
<button name="admin_photo">Change Photo</button>
</form>
</td>

</tr>
<?php endforeach; ?>
</table>

<br>
<a href="dashboard.php">⬅ Back to Admin Dashboard</a>

</body>
</html>
