<?php
ini_set('display_errors',1);
error_reporting(E_ALL);

session_start();
include __DIR__ . '/../config/db.php';

$error = "";

if (isset($_POST['login'])) {

    $username = trim($_POST['username']);
    $password = trim($_POST['password']);

    if ($username == "" || $password == "") {
        $error = "All fields required";
    } else {

        // ✅ CONFIRMED TABLE + COLUMNS
        $q = $conn->prepare(
            "SELECT * FROM admins WHERE username=? AND password=? LIMIT 1"
        );
        $q->execute([
            $username,
            md5($password)
        ]);

        $admin = $q->fetch(PDO::FETCH_ASSOC);

        if (!$admin) {
            $error = "Invalid username or password";
        } else {
            $_SESSION['admin_id'] = $admin['id'];
            header("Location: dashboard.php");
            exit;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Admin Login • DrJomax</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<style>
*{box-sizing:border-box;font-family:Inter,system-ui;}
body{
    margin:0;
    min-height:100vh;
    display:flex;
    align-items:center;
    justify-content:center;
    background:radial-gradient(circle at top,#0f172a,#000);
    color:#fff;
}
.login-box{
    width:100%;
    max-width:420px;
    background:#020617;
    border-radius:16px;
    padding:32px;
    box-shadow:0 20px 60px rgba(0,0,0,.6);
    border:1px solid #0f2f1c;
}
.logo{
    text-align:center;
    font-size:26px;
    font-weight:800;
    margin-bottom:6px;
}
.logo span{color:#7CFF00;}
.sub{
    text-align:center;
    color:#94a3b8;
    font-size:14px;
    margin-bottom:25px;
}
.input{margin-bottom:16px;}
.input label{
    display:block;
    font-size:13px;
    margin-bottom:6px;
    color:#cbd5f5;
}
.input input{
    width:100%;
    padding:14px;
    border-radius:10px;
    border:1px solid #1e293b;
    background:#020617;
    color:#fff;
}
.input input:focus{
    border-color:#7CFF00;
    box-shadow:0 0 0 2px rgba(124,255,0,.15);
}
button{
    width:100%;
    padding:14px;
    border:none;
    border-radius:12px;
    background:#7CFF00;
    color:#000;
    font-weight:700;
    font-size:16px;
    cursor:pointer;
}
button:hover{background:#5ee500;}
.error{
    background:#2a0000;
    border:1px solid #ff3b3b;
    color:#ffb4b4;
    padding:10px;
    border-radius:10px;
    margin-bottom:15px;
    font-size:14px;
    text-align:center;
}
.footer{
    margin-top:20px;
    text-align:center;
    font-size:12px;
    color:#64748b;
}
</style>
</head>

<body>

<div class="login-box">
    <div class="logo">Dr<span>Jomax</span> Admin</div>
    <div class="sub">Administrator Access</div>

    <?php if($error): ?>
        <div class="error"><?= $error ?></div>
    <?php endif; ?>

    <form method="post">
        <div class="input">
            <label>Username</label>
            <input type="text" name="username" required>
        </div>

        <div class="input">
            <label>Password</label>
            <input type="password" name="password" required>
        </div>

        <button type="submit" name="login">Sign In</button>
    </form>

    <div class="footer">
        © <?= date('Y'); ?> DrJomax Admin Panel
    </div>
</div>

</body>
</html>
