<?php
session_start();
if(!isset($_SESSION['admin_id'])){
    header("Location: login.php");
    exit;
}

if(empty($_POST['files'])){
    die("No files selected");
}

$zip = new ZipArchive();
$zipName = "coupon_cards_".date("Ymd_His").".zip";

$zip->open($zipName, ZipArchive::CREATE);

foreach($_POST['files'] as $file){
    $path = __DIR__."/coupon_cards_png/".$file;
    if(file_exists($path)){
        $zip->addFile($path, $file);
    }
}
$zip->close();

header("Content-Type: application/zip");
header("Content-Disposition: attachment; filename=$zipName");
readfile($zipName);
unlink($zipName);
exit;
