<?php
session_start();
if(!isset($_SESSION['admin'])){
    die("Access denied");
}

if(empty($_POST['cards'])){
    die("No cards selected");
}

$pngDir = __DIR__."/coupon_cards_png/";
$zipName = "selected_coupon_png.zip";

$zip = new ZipArchive();
$zip->open($zipName, ZipArchive::CREATE | ZipArchive::OVERWRITE);

foreach($_POST['cards'] as $file){
    $path = realpath($pngDir.$file);
    if($path && strpos($path, realpath($pngDir)) === 0){
        $zip->addFile($path, $file);
    }
}

$zip->close();

header("Content-Type: application/zip");
header("Content-Disposition: attachment; filename=$zipName");
header("Content-Length: " . filesize($zipName));
readfile($zipName);
unlink($zipName);
exit;
