<?php
session_start();
if(!isset($_SESSION['admin'])){
    die("Access denied");
}

if(empty($_POST['cards'])){
    die("No cards selected");
}

$cardDir = __DIR__ . "/coupon_cards/";
$zipName = "selected_coupon_cards.zip";

$zip = new ZipArchive();
$zip->open($zipName, ZipArchive::CREATE | ZipArchive::OVERWRITE);

foreach($_POST['cards'] as $file){
    $path = realpath($cardDir.$file);
    if($path && strpos($path, realpath($cardDir)) === 0){
        $zip->addFile($path, $file);
    }
}

$zip->close();

header("Content-Type: application/zip");
header("Content-Disposition: attachment; filename=$zipName");
header("Content-Length: " . filesize($zipName));

readfile($zipName);
unlink($zipName);
exit;
