<?php
session_start();
if(!isset($_SESSION['admin'])){
    die("Access denied");
}

$cardDir = __DIR__ . "/coupon_cards/";
$zipFile = __DIR__ . "/coupon_cards.zip";

if(!is_dir($cardDir)){
    die("Card folder not found");
}

$files = glob($cardDir . "*.{html,png}", GLOB_BRACE);

if(empty($files)){
    die("No coupon cards found");
}

$zip = new ZipArchive();
if($zip->open($zipFile, ZipArchive::CREATE | ZipArchive::OVERWRITE) !== TRUE){
    die("Could not create ZIP file");
}

foreach($files as $file){
    $zip->addFile($file, basename($file));
}

$zip->close();

/* FORCE DOWNLOAD */
header("Content-Type: application/zip");
header("Content-Disposition: attachment; filename=coupon_cards.zip");
header("Content-Length: " . filesize($zipFile));

readfile($zipFile);

/* OPTIONAL: delete zip after download */
// unlink($zipFile);

exit;
