<?php
session_start();
if(!isset($_SESSION['admin_id'])){
    header("Location: login.php");
    exit;
}
?>

<?php include "layout/header.php"; ?>
<?php include "layout/sidebar.php"; ?>

<div class="main">

<!-- TOP BAR -->
<div class="topbar">
    <div>Welcome <b>Admin</b></div>
    <div><?= date("d M Y"); ?></div>
</div>

<!-- DASHBOARD GRID -->
<div class="grid">

    <!-- USERS -->
    <div class="card">
        👥 Users<br><br>
        <b>Manage all users</b><br><br>
        <a class="quick" href="users.php">Open</a>
    </div>

    <!-- CREATE COUPON -->
    <div class="card">
        🎟 Create Coupons<br><br>
        <b>Single / Bulk coupon create</b><br><br>
        <a class="quick" href="coupon-create.php">Create Coupon</a>
    </div>

    <!-- COUPON GALLERY (FIXED) -->
    <div class="card">
        🖼 Coupon Cards<br><br>
        <b>PNG Cards • Download • ZIP</b><br><br>
        <a class="quick" href="coupon-gallery.php">Open Gallery</a>
    </div>

    <!-- REDEEM HISTORY -->
    <div class="card">
        📷 QR Redeems<br><br>
        <b>Coupon redeem history</b><br><br>
        <a class="quick" href="coupon-history.php">View History</a>
    </div>

    <!-- WITHDRAW REQUESTS -->
    <div class="card">
        💸 Withdraw Requests<br><br>
        <b>Approve / Reject</b><br><br>
        <a class="quick" href="withdraw-requests.php">Manage</a>
    </div>

    <!-- SETTINGS -->
    <div class="card">
        ⚙ Settings<br><br>
        <b>Withdraw • System</b><br><br>
        <a class="quick" href="withdraw-setting.php">Open Settings</a>
    </div>

</div>

<br>

<!-- CHART -->
<div class="card">
    <h3>📈 Weekly Redeem Chart</h3>
    <canvas id="chart"></canvas>
</div>

</div>

<script>
new Chart(document.getElementById('chart'), {
    type: 'line',
    data: {
        labels: ['Mon','Tue','Wed','Thu','Fri','Sat','Sun'],
        datasets: [{
            label: 'Redeems',
            data: [3,6,4,9,5,11,7],
            borderColor: '#6366f1',
            backgroundColor: 'rgba(99,102,241,.15)',
            tension: .4,
            fill:true
        }]
    }
});
</script>

<?php include "layout/footer.php"; ?>
