<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

include "auth.php";
include "../config/db.php";

$msg = "";

/* UNIQUE CODE FUNCTIONS */
function generateCouponCode($conn) {
    do {
        $code = "DRJ-" . strtoupper(substr(uniqid(), -6));
        $check = $conn->prepare("SELECT id FROM coupons WHERE coupon_code=?");
        $check->execute([$code]);
    } while ($check->rowCount() > 0);
    return $code;
}

function generateProductCode() {
    return "DRJ-PROD-" . strtoupper(substr(uniqid(), -5));
}

if (isset($_POST['create'])) {

    $name   = $_POST['coupon_name'];
    $size   = $_POST['coupon_size'];
    $amount = $_POST['amount'];
    $expiry = $_POST['expiry_date'];
    $total  = (int)$_POST['total'];

    if ($total < 1) $total = 1;

    $stmt = $conn->prepare(
        "INSERT INTO coupons
        (coupon_name,coupon_size,amount,coupon_code,product_code,qr_code,expiry_date)
        VALUES (?,?,?,?,?,?,?)"
    );

    $success = 0;

    for ($i = 1; $i <= $total; $i++) {

        try {
            $couponCode  = generateCouponCode($conn);
            $productCode = generateProductCode();
            $qr = "https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=".$couponCode;

            $stmt->execute([
                $name,
                $size,
                $amount,
                $couponCode,
                $productCode,
                $qr,
                $expiry
            ]);

            $success++;

        } catch (Exception $e) {
            // skip failed insert, continue loop
        }
    }

    $msg = "✅ $success / $total Coupons Created Successfully";
}
?>

<h2>Create Coupon (Single / Bulk)</h2>

<form method="post">

<input type="text" name="coupon_name" placeholder="Coupon Name" required><br><br>

<input type="text" name="coupon_size" placeholder="Coupon Size" required><br><br>

<input type="number" name="amount" placeholder="Amount" required><br><br>

<label>Expiry Date</label><br>
<input type="date" name="expiry_date" required><br><br>

<label>Total Coupons</label><br>
<input type="number" name="total" value="1" min="1" required><br><br>

<button name="create">Create Coupon</button>

</form>

<p style="color:green;"><b><?= $msg ?></b></p>

<hr>

<h3>Latest Coupons</h3>

<?php
$all = $conn->query("SELECT * FROM coupons ORDER BY id DESC LIMIT 20")->fetchAll();
foreach ($all as $c):
?>
<div style="border:1px solid #ccc;padding:10px;margin:10px 0;">
<b><?= $c['coupon_name'] ?></b><br>
Coupon: <?= $c['coupon_code'] ?><br>
Product Code: <b><?= $c['product_code'] ?></b><br>
Expiry: <?= $c['expiry_date'] ?><br>
Status: <?= $c['is_used'] ? "USED" : "ACTIVE" ?><br>
<img src="<?= $c['qr_code'] ?>" width="80">
</div>
<?php endforeach; ?>
