<?php
session_start();
include "../config/db.php";
if(!isset($_SESSION['admin'])) exit;

$q = $conn->query("SELECT * FROM coupons ORDER BY id DESC");
?>

<!DOCTYPE html>
<html>
<head>
<title>Coupon Stock</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
body{background:#000;color:#fff;font-family:Arial;padding:30px;}
table{width:100%;border-collapse:collapse;}
th,td{border:1px solid #444;padding:10px;text-align:center;}
th{background:#111;}
img{width:80px;height:80px;}
</style>
</head>

<body>

<h2>Coupon Stock</h2>

<table>
<tr>
<th>Name</th>
<th>Coupon Code</th>
<th>QR</th>
<th>Size</th>
<th>Amount</th>
<th>Expiry</th>
<th>Product Code</th>
<th>Status</th>
</tr>

<?php foreach($q as $c): ?>
<tr>
<td><?= htmlspecialchars($c['coupon_name']); ?></td>
<td><?= $c['coupon_code']; ?></td>
<td>
<?php if($c['qr_code']): ?>
<img src="<?= $c['qr_code']; ?>">
<?php else: ?>
No QR
<?php endif; ?>
</td>
<td><?= $c['size']; ?></td>
<td><?= $c['amount']; ?></td>
<td><?= $c['expiry_date']; ?></td>
<td><?= $c['product_code']; ?></td>
<td><?= $c['is_used'] ? 'Used' : 'Available'; ?></td>
</tr>
<?php endforeach; ?>

</table>

<br>
<a href="dashboard.php" style="color:#7CFF00;">⬅ Back</a>

</body>
</html>
