<?php
session_start();
include "../config/db.php";

if(!isset($_SESSION['admin'])){
    header("Location: index.php");
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
<title>Coupon Redeem History</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
body{background:#000;color:#fff;font-family:Arial;padding:20px;}
table{width:100%;border-collapse:collapse;}
th,td{border:1px solid #444;padding:8px;font-size:14px;}
th{background:#111;}
</style>
</head>
<body>

<h2>🧾 Coupon Redeem History</h2>

<table>
<tr>
<th>ID</th>
<th>User</th>
<th>Mobile</th>
<th>Coupon Name</th>
<th>Coupon Code</th>
<th>Size</th>
<th>Product</th>
<th>Amount</th>
<th>Date</th>
</tr>

<?php
$q = $conn->query(
    "SELECT 
        r.id,
        u.username,
        u.mobile,
        c.coupon_name,
        r.coupon_code,
        r.size,
        r.product_code,
        r.amount,
        r.redeemed_at
     FROM coupon_redeems r
     JOIN users u ON u.id = r.user_id
     LEFT JOIN coupons c 
        ON c.coupon_code = r.coupon_code
     ORDER BY r.redeemed_at DESC"
);

if($q->rowCount()==0){
    echo '<tr><td colspan="9">No redeem data found</td></tr>';
}

foreach($q as $r):
?>
<tr>
<td><?= $r['id']; ?></td>
<td><?= htmlspecialchars($r['username']); ?></td>
<td><?= htmlspecialchars($r['mobile']); ?></td>
<td><?= htmlspecialchars($r['coupon_name'] ?? '-'); ?></td>
<td><?= htmlspecialchars($r['coupon_code']); ?></td>
<td><?= htmlspecialchars($r['size'] ?? '-'); ?></td>
<td><?= htmlspecialchars($r['product_code']); ?></td>
<td>₹<?= number_format($r['amount'],2); ?></td>
<td><?= $r['redeemed_at']; ?></td>
</tr>
<?php endforeach; ?>
</table>

<br>
<a href="dashboard.php">⬅ Back to Dashboard</a>

</body>
</html>
