<?php
session_start();
if(!isset($_SESSION['admin_id'])){
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Coupon Card Gallery</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<style>
body{
    background:#0f172a;
    color:#e5e7eb;
    font-family:Arial;
    padding:20px;
}
h2{margin-bottom:10px}
.grid{
    display:grid;
    grid-template-columns:repeat(auto-fit,minmax(220px,1fr));
    gap:16px;
}
.card{
    background:#020617;
    border:1px solid #1e293b;
    border-radius:14px;
    padding:12px;
    text-align:center;
}
.card img{
    width:100%;
    border-radius:10px;
    margin-bottom:8px;
}
.actions{
    margin-top:6px;
}
.actions a{
    display:inline-block;
    margin:4px;
    padding:6px 10px;
    background:#7CFF00;
    color:#000;
    text-decoration:none;
    font-size:13px;
    border-radius:6px;
    font-weight:bold;
}
.checkbox{
    margin-bottom:6px;
}
.top-actions{
    margin-bottom:15px;
}
button{
    padding:10px 16px;
    border:none;
    background:#7CFF00;
    font-weight:bold;
    border-radius:8px;
    cursor:pointer;
}
</style>
</head>

<body>

<h2>🖼 Coupon Card Gallery</h2>

<form method="post" action="download-zip.php">
<div class="top-actions">
    <button type="submit">⬇ Download Selected (ZIP)</button>
</div>

<div class="grid">

<?php
$dir = __DIR__ . "/coupon_cards_png";
$files = glob($dir."/*.png");

if(!$files){
    echo "<p>No coupon cards found</p>";
}

foreach($files as $file){
    $name = basename($file);
    echo "
    <div class='card'>
        <div class='checkbox'>
            <input type='checkbox' name='files[]' value='$name'>
        </div>
        <img src='coupon_cards_png/$name'>
        <div class='actions'>
            <a href='coupon_cards_png/$name' download>Download</a>
        </div>
    </div>
    ";
}
?>

</div>
</form>

<br>
<a href="dashboard.php" style="color:#7CFF00;">⬅ Back to Dashboard</a>

</body>
</html>
