<?php
ini_set('display_errors',1);
error_reporting(E_ALL);

session_start();
include "../config/db.php";

if(!isset($_SESSION['admin_id'])){
    header("Location: login.php");
    exit;
}

/* ===============================
   SAFE PNG GENERATOR
================================ */
function generateCouponPNG($data){
    $w = 600; $h = 360;
    $im = imagecreatetruecolor($w,$h);

    $black = imagecolorallocate($im,0,0,0);
    $white = imagecolorallocate($im,255,255,255);
    $green = imagecolorallocate($im,124,255,0);

    imagefill($im,0,0,$black);

    if(!empty($data['bg']) && file_exists($data['bg'])){
        $bg = imagecreatefromstring(file_get_contents($data['bg']));
        imagecopyresampled(
            $im,$bg,0,0,0,0,
            $w,$h,imagesx($bg),imagesy($bg)
        );
        imagedestroy($bg);
    }

    imagestring($im,5,20,20,$data['name'],$white);
    imagestring($im,4,20,90,"Code: ".$data['code'],$white);
    imagestring($im,4,20,130,"Size: ".$data['size'],$white);
    imagestring($im,4,20,170,"Amount: Rs ".$data['amount'],$white);
    imagestring($im,4,200,330,"Product: ".$data['product'],$green);

    $qrRaw = @file_get_contents(
        "https://api.qrserver.com/v1/create-qr-code/?size=120x120&data=".$data['code']
    );
    if($qrRaw){
        $qr = imagecreatefromstring($qrRaw);
        imagecopy($im,$qr,450,90,0,0,120,120);
        imagedestroy($qr);
    }

    imagepng($im,$data['save']);
    imagedestroy($im);
}

$msg = "";

/* ===============================
   CREATE COUPON
================================ */
if(isset($_POST['create'])){

    $coupon_name = trim($_POST['coupon_name']);
    $size        = trim($_POST['size']);
    $amount      = (float)$_POST['amount'];
    $expiry      = $_POST['expiry'];
    $qty         = (int)$_POST['quantity'];
    $ref_percent = (int)$_POST['ref_percent'];

    if($qty < 1) $qty = 1;

    if(!is_dir(__DIR__."/card_bg")) mkdir(__DIR__."/card_bg",0777,true);
    if(!is_dir(__DIR__."/coupon_cards_png")) mkdir(__DIR__."/coupon_cards_png",0777,true);

    $bgFile = "";
    if(!empty($_FILES['bg_image']['tmp_name'])){
        $ext = strtolower(pathinfo($_FILES['bg_image']['name'],PATHINFO_EXTENSION));
        if(in_array($ext,['png','jpg','jpeg','webp'])){
            $bgFile = "bg_".time().".".$ext;
            move_uploaded_file(
                $_FILES['bg_image']['tmp_name'],
                __DIR__."/card_bg/".$bgFile
            );
        }
    }

    for($i=1;$i<=$qty;$i++){

        $coupon_code  = "DRJ-".strtoupper(substr(uniqid(),-6));
        $product_code = "PROD-".strtoupper(substr(uniqid(),-5));

        $conn->prepare(
            "INSERT INTO coupons
            (coupon_name,coupon_code,size,amount,expiry_date,product_code,card_bg,ref_percent)
            VALUES (?,?,?,?,?,?,?,?)"
        )->execute([
            $coupon_name,
            $coupon_code,
            $size,
            $amount,
            $expiry,
            $product_code,
            $bgFile,
            $ref_percent
        ]);

        generateCouponPNG([
            "name"=>$coupon_name,
            "code"=>$coupon_code,
            "size"=>$size,
            "amount"=>$amount,
            "product"=>$product_code,
            "bg"=>$bgFile ? __DIR__."/card_bg/".$bgFile : "",
            "save"=>__DIR__."/coupon_cards_png/".$coupon_code.".png"
        ]);
    }

    $msg = "✅ $qty Coupon(s) Created Successfully";
}
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Create Coupon</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<style>
body{background:#000;color:#fff;font-family:Arial;padding:20px;}
input,button{width:100%;padding:10px;margin:6px 0;}
button{background:#7CFF00;border:none;font-weight:bold;cursor:pointer;}

#liveCard{
width:360px;height:220px;margin:20px auto;
border-radius:16px;position:relative;
overflow:hidden;background:#000;
border:2px solid #7CFF00;
}
#bgPreview{
position:absolute;width:100%;height:100%;
object-fit:cover;display:none;
}
.content{
position:relative;z-index:2;padding:16px;
}
.product{
position:absolute;bottom:8px;width:100%;
text-align:center;color:#7CFF00;font-size:12px;
}
</style>
</head>

<body>

<h2>🎟 Create Coupon</h2>

<?php if($msg): ?>
<p style="color:#7CFF00;"><?= $msg ?></p>
<?php endif; ?>

<h3 style="text-align:center;">🖼 LIVE COUPON PREVIEW</h3>

<div id="liveCard">
<img id="bgPreview">
<div class="content">
<b id="p_name">Coupon Name</b><br><br>
Code: AUTO<br>
Size: <span id="p_size">-</span><br>
Amount: Rs <span id="p_amount">0</span>
</div>
<div class="product">Product Code: AUTO</div>
</div>

<form method="post" enctype="multipart/form-data">

<input type="text" name="coupon_name" id="coupon_name" placeholder="Coupon Name" required>
<input type="text" name="size" id="size" placeholder="Size" required>
<input type="number" name="amount" id="amount" placeholder="Amount" required>
<input type="number" name="ref_percent" placeholder="Referral % (0-100)" value="0">
<input type="date" name="expiry" required>
<input type="number" name="quantity" value="1" min="1">
<input type="file" name="bg_image" id="bg_input" accept="image/*">

<button name="create">Create Coupon</button>
</form>

<script>
coupon_name.oninput=e=>p_name.innerText=e.target.value||"Coupon Name";
size.oninput=e=>p_size.innerText=e.target.value||"-";
amount.oninput=e=>p_amount.innerText=e.target.value||"0";

bg_input.onchange=e=>{
 const f=e.target.files[0];
 if(!f) return;
 const r=new FileReader();
 r.onload=x=>{
  bgPreview.src=x.target.result;
  bgPreview.style.display="block";
 };
 r.readAsDataURL(f);
};
</script>

<br>
<a href="dashboard.php" style="color:#7CFF00;">⬅ Back to Dashboard</a>

</body>
</html>
