<?php
session_start();
include "../config/db.php";

if(!isset($_SESSION['admin'])){
    die("Access denied");
}

require_once "coupon-create.php"; 
// ⚠️ is file me generateCouponCard() function hona chahiye

$msg = "";

if(isset($_POST['bulk_create'])){

    $coupon_name = $_POST['coupon_name'];
    $size        = $_POST['size'];
    $amount      = $_POST['amount'];
    $expiry      = $_POST['expiry'];
    $qty         = (int)$_POST['qty'];

    // SAVE BACKGROUND
    $bgFile = "";
    if(!empty($_FILES['bg_image']['tmp_name'])){
        $ext = pathinfo($_FILES['bg_image']['name'], PATHINFO_EXTENSION);
        $bgFile = "bg_".time().".".$ext;
        move_uploaded_file(
            $_FILES['bg_image']['tmp_name'],
            __DIR__."/card_bg/".$bgFile
        );
    }

    for($i=1;$i<=$qty;$i++){

        $coupon_code  = "DRJ-".strtoupper(substr(uniqid(), -6));
        $product_code = "PROD-".strtoupper(substr(uniqid(), -5));

        // DB INSERT
        $conn->prepare(
            "INSERT INTO coupons
            (coupon_name,coupon_code,size,amount,expiry_date,product_code,card_bg)
            VALUES (?,?,?,?,?,?,?)"
        )->execute([
            $coupon_name,
            $coupon_code,
            $size,
            $amount,
            $expiry,
            $product_code,
            $bgFile
        ]);

        // AUTO CARD GENERATE
        generateCouponCard([
            'coupon_name'  => $coupon_name,
            'coupon_code'  => $coupon_code,
            'size'         => $size,
            'amount'       => $amount,
            'product_code' => $product_code,
            'card_bg'      => $bgFile
        ]);
    }

    $msg = "✅ $qty Coupons + Cards Created Successfully";
}
?>

<!DOCTYPE html>
<html>
<head>
<title>Bulk Coupon Create</title>
<style>
body{background:#000;color:#fff;font-family:Arial;padding:20px;}
input,button{width:100%;padding:10px;margin:6px 0;}
button{background:#7CFF00;border:none;font-weight:bold;}
</style>
</head>
<body>

<h2>📦 Bulk Coupon Create</h2>

<form method="post" enctype="multipart/form-data">
<input name="coupon_name" placeholder="Coupon Name" required>
<input name="size" placeholder="Size" required>
<input name="amount" placeholder="Amount" required>
<input type="date" name="expiry" required>
<input type="number" name="qty" placeholder="How many coupons?" required>

<input type="file" name="bg_image" accept="image/*">

<button name="bulk_create">Create Bulk Coupons</button>
</form>

<p style="color:#7CFF00;"><?= $msg; ?></p>

<a href="dashboard.php" style="color:#7CFF00;">⬅ Back</a>
</body>
</html>
