<?php
session_start();
include "../config/db.php";

if(!isset($_SESSION['admin'])){
    die("Access denied");
}

$cardDir = __DIR__."/coupon_cards/";
$bgDir   = __DIR__."/card_bg/";

if(!is_dir($cardDir)){
    mkdir($cardDir,0777,true);
}

$q = $conn->query(
    "SELECT coupon_name,coupon_code,size,amount,product_code,card_bg 
     FROM coupons ORDER BY id DESC"
);

$done = 0;

while($c = $q->fetch(PDO::FETCH_ASSOC)){

    $bgImg = "";
    if(!empty($c['card_bg']) && file_exists($bgDir.$c['card_bg'])){
        $bgData = base64_encode(file_get_contents($bgDir.$c['card_bg']));
        $bgImg = "data:image/png;base64,$bgData";
    }

    $qr = "https://api.qrserver.com/v1/create-qr-code/?size=120x120&data=".$c['coupon_code'];

$cardHtml = '
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Coupon Card</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
body{background:#111;color:#fff;font-family:Arial;padding:20px;text-align:center;}

#card{
width:340px;height:200px;margin:auto;border-radius:18px;
padding:16px;position:relative;overflow:hidden;
background:#000;
}

.bg{
position:absolute;
top:0;left:0;
width:100%;height:100%;
object-fit:cover;
z-index:0;
}

.content{
position:relative;
z-index:2;
}

.qr{
width:80px;
position:absolute;
right:14px;
bottom:60px;
z-index:3;
}

.product{
position:absolute;
bottom:8px;
left:0;width:100%;
text-align:center;
font-size:12px;
color:#7CFF00;
font-weight:bold;
z-index:3;
}

button{
margin-top:18px;
padding:12px 20px;
background:#7CFF00;
border:none;
border-radius:6px;
font-weight:bold;
cursor:pointer;
}
</style>
</head>

<body>

<div id="card">';

if($bgImg){
$cardHtml .= '<img src="'.$bgImg.'" class="bg">';
}

$cardHtml .= '
<div class="content">
<b>'.htmlspecialchars($c['coupon_name']).'</b><br><br>
Code: '.$c['coupon_code'].'<br>
Size: '.$c['size'].'<br>
Amount: Rs. '.$c['amount'].'
</div>

<img class="qr" src="'.$qr.'">
<div class="product">Product Code: '.$c['product_code'].'</div>

</div>

<button onclick="downloadPNG()">⬇ Download PNG</button>

<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script>
function downloadPNG(){
 html2canvas(document.getElementById("card"),{
    scale:2,
    useCORS:true
 }).then(c=>{
  let a=document.createElement("a");
  a.download="'.$c['coupon_code'].'.png";
  a.href=c.toDataURL("image/png");
  a.click();
 });
}
</script>

</body>
</html>';

    file_put_contents(
        $cardDir.$c['coupon_code'].".html",
        $cardHtml
    );

    $done++;
}
?>
<!DOCTYPE html>
<html>
<body style="background:#000;color:#7CFF00;font-family:Arial;padding:30px;">
<h2>✅ <?= $done ?> Cards Regenerated Successfully</h2>
<a href="dashboard.php" style="color:#7CFF00;">⬅ Back to Dashboard</a>
</body>
</html>
