<?php
session_start();
include "../config/db.php";

if(!isset($_SESSION['admin'])){
    die("Access denied");
}

$msg = "";

/* CREATE FOLDERS */
$cardDir = __DIR__."/coupon_cards/";
$bgDir   = __DIR__."/card_bg/";

if(!is_dir($cardDir)) mkdir($cardDir,0777,true);
if(!is_dir($bgDir)) mkdir($bgDir,0777,true);

if(isset($_POST['create_bulk'])){

    $coupon_name = $_POST['coupon_name'];
    $size        = $_POST['size'];
    $amount      = $_POST['amount'];
    $expiry      = $_POST['expiry'];
    $qty         = (int)$_POST['qty'];

    /* SAVE BACKGROUND */
    $bgFile = "";
    if(!empty($_FILES['bg_image']['tmp_name'])){
        $ext = pathinfo($_FILES['bg_image']['name'], PATHINFO_EXTENSION);
        $bgFile = "bg_".time().".".$ext;
        move_uploaded_file(
            $_FILES['bg_image']['tmp_name'],
            $bgDir.$bgFile
        );
    }

    $done = 0;

    for($i=1; $i<=$qty; $i++){

        $coupon_code  = "DRJ-".strtoupper(substr(uniqid(), -6));
        $product_code = "PROD-".strtoupper(substr(uniqid(), -5));

        /* DB INSERT */
        $conn->prepare(
            "INSERT INTO coupons
            (coupon_name,coupon_code,size,amount,expiry_date,product_code,is_used,card_bg)
            VALUES (?,?,?,?,?,?,0,?)"
        )->execute([
            $coupon_name,
            $coupon_code,
            $size,
            $amount,
            $expiry,
            $product_code,
            $bgFile
        ]);

        /* CARD HTML */
        $qr = "https://api.qrserver.com/v1/create-qr-code/?size=120x120&data=".$coupon_code;

        '.$bgStyle.'; = '
        <div style="
        width:340px;height:200px;border-radius:18px;
        padding:16px;color:#fff;
        $bgStyle = "#1a1a1a";

        if($bgFile && file_exists($bgDir.$bgFile)){
        $imgData = base64_encode(file_get_contents($bgDir.$bgFile));
        $bgStyle = "url(data:image/jpeg;base64,$imgData)";
        }
        background-size:cover;background-position:center;
        font-family:Arial;position:relative;
        ">
        <b>'.$coupon_name.'</b><br><br>

        Code: '.$coupon_code.'<br>
        Size: '.$size.'<br>
        Amount: Rs. '.$amount.'

        <img src="'.$qr.'" style="
        width:80px;
        position:absolute;
        right:14px;
        bottom:60px;
        ">

        <div style="
        position:absolute;
        bottom:8px;
        left:0;
        width:100%;
        text-align:center;
        font-size:12px;
        color:#7CFF00;
        font-weight:bold;
        ">
        Product Code: '.$product_code.'
        </div>
        </div>';

        file_put_contents(
            $cardDir.$coupon_code.".html",
            '.$bgStyle.';
        );

        $done++;
    }

    $msg = "✅ $done coupons & cards created successfully";
}
?>
<!DOCTYPE html>
<html>
<head>
<title>Bulk Create Coupons</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
body{background:#000;color:#fff;font-family:Arial;padding:20px;}
input,button{width:100%;padding:10px;margin:6px 0;}
</style>
</head>
<body>

<h2>📦 Bulk Create Coupon Cards</h2>

<form method="post" enctype="multipart/form-data">
<input name="coupon_name" placeholder="Coupon Name" required>
<input name="size" placeholder="Size (S/M/L)" required>
<input name="amount" placeholder="Amount" required>
<input type="date" name="expiry" required>
<input type="number" name="qty" placeholder="Quantity" min="1" required>

<input type="file" name="bg_image" accept="image/*">

<button name="create_bulk">Create Bulk Coupons</button>
</form>

<p style="color:#7CFF00;"><?= $msg; ?></p>

<hr>
<a href="dashboard.php" style="color:#7CFF00;">⬅ Back to Dashboard</a>

</body>
</html>
